/*
 * Decompiled with CFR 0.152.
 */
package make.setup;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import make.setup.Console;

public final class SPortExtractor
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private static final boolean USE_CONSOLE = true;
    public static final String sPortReleaseID = "SPort-1.0";
    public static String sPortRevisionID = "?";
    private static final String simulaInstallSubdirectory = "Simula" + File.separatorChar + "SPort-1.0";
    private static final String programAndVersion = "SPort 1.0";
    private static File INSTALL_DIR;
    private static File BATCH_FILE;
    private static String setupDated;
    private static ImageIcon simulaIcon;
    private static String sPortJarFileName;
    private static String targetDir;
    private static int nExtractedFiles;
    private static boolean compilerBatWasWritten;
    private String myClassName;
    private JTextField installDirField;
    private static Console console;
    private static JFrame mainFrame;

    public static void main(String[] args) {
        IO.println((Object)("SPortExtractor: user.home=" + System.getProperty("user.home")));
        IO.println((Object)("SPortExtractor: user.dir=" + System.getProperty("user.dir")));
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("OptionPane.messagebackground", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        SPortExtractor simulaExtractor = new SPortExtractor();
        String jarFileName = simulaExtractor.getJarFileName();
        if (jarFileName == null) {
            jarFileName = "C:/GitHub/Binaries/setup.jar";
        }
        boolean ok = simulaExtractor.extract(jarFileName);
        SPortExtractor.write_RunSimulaEditor_Bat();
        SPortExtractor.writeSetupProperties();
        SPortExtractor.askRunSimula();
        if (console != null) {
            if (ok) {
                console.write("=====================================================\n");
                console.write("S-Port Simula was successfully installed in\n\n");
                console.write("       " + String.valueOf(INSTALL_DIR) + "\n\n");
            }
            while (true) {
                Thread.yield();
            }
        }
        System.exit(ok ? 0 : 1);
    }

    SPortExtractor() {
        URL url = this.getClass().getResource("sim.png");
        simulaIcon = url == null ? null : new ImageIcon(url);
        mainFrame = this;
        int frameHeight = 300;
        int frameWidth = 550;
        this.setSize(frameWidth, frameHeight);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        IO.println((Object)"Open ConsolePanel");
        console = new Console();
        mainFrame.setTitle("Installing S-Port Simula");
        mainFrame.add(console);
    }

    private static void write_RunSimulaEditor_Bat() {
        String text;
        String fileName;
        boolean windows;
        boolean bl = windows = File.separatorChar == '\\';
        if (windows) {
            fileName = "RunSimulaEditor.bat";
            text = "CHCP 65001\r\nrem *** Call S-Port Simula Editor\r\ncd " + String.valueOf(INSTALL_DIR) + "\r\njava -jar SIM.jar\r\npause\r\n";
        } else {
            fileName = "RunSimulaEditor.sh";
            text = "echo Call S-Port Simula Editor;\ncd " + String.valueOf(INSTALL_DIR) + "\njava -jar simula.jar\necho Press enter to continue; read dummy;\n";
        }
        IO.println((Object)("INSTALL_DIR=" + String.valueOf(INSTALL_DIR)));
        IO.println((Object)("fileName=" + fileName));
        IO.println((Object)("text=" + text));
        BATCH_FILE = new File(INSTALL_DIR, fileName);
        IO.println((Object)("BATCH_FILE=" + String.valueOf(BATCH_FILE)));
        try {
            if (console != null) {
                console.write("Write: " + String.valueOf(BATCH_FILE) + "\n");
            }
            try {
                BATCH_FILE.setExecutable(true, false);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            FileOutputStream oupt = new FileOutputStream(BATCH_FILE);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)oupt, Charset.forName("UTF-8"));
            writer.write(text);
            writer.flush();
            writer.close();
            compilerBatWasWritten = true;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "SORRY: Can't write " + String.valueOf(BATCH_FILE), "Error", 0);
            e.printStackTrace();
        }
    }

    private static void writeSetupProperties() {
        block15: {
            Properties simulaProperties = new Properties();
            File simulaPropertiesFile = null;
            File USER_HOME = new File(System.getProperty("user.home"));
            File dotSimula = new File(USER_HOME, ".simula");
            dotSimula.mkdir();
            simulaPropertiesFile = new File(dotSimula, "sPortSetup.xml");
            simulaProperties.put("sPort.setup.dated", setupDated);
            simulaProperties.put("sPort.installed", new Date().toString());
            simulaProperties.put("sPort.version", sPortReleaseID);
            simulaProperties.put("sPort.revision", sPortRevisionID);
            simulaProperties.put("sPort.home", INSTALL_DIR.getParentFile().toString());
            simulaProperties.list(System.out);
            OutputStream out = null;
            try {
                try {
                    try {
                        simulaPropertiesFile.setReadable(true, false);
                        simulaPropertiesFile.setWritable(true, false);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    out = new FileOutputStream(simulaPropertiesFile);
                    simulaProperties.storeToXML(out, "S-Port Setup Properties");
                    if (console != null) {
                        console.write("Write: " + String.valueOf(simulaPropertiesFile) + "\n");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (out == null) break block15;
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private String getJarFileName() {
        this.myClassName = this.getClass().getName().replace('.', '/') + ".class";
        IO.println((Object)("SPortExtractor.getJarFileName: myClassName=" + this.myClassName));
        URL urlJar = ClassLoader.getSystemResource(this.myClassName);
        String urlEncStr = urlJar.toString();
        try {
            String urlStr = URLDecoder.decode(urlEncStr, "UTF-8");
            int from = "jar:file:".length();
            int to = urlStr.indexOf("!/");
            String jarFileName = urlStr.substring(from, to);
            IO.println((Object)("SPortExtractor.getJarFileName: myClassName=" + this.myClassName));
            IO.println((Object)("SPortExtractor.getJarFileName: urlEncStr=" + urlEncStr));
            IO.println((Object)("SPortExtractor.getJarFileName: urlStr=" + urlStr));
            IO.println((Object)("SPortExtractor.getJarFileName: jarFileName=" + jarFileName));
            return jarFileName;
        }
        catch (Exception e) {
            return null;
        }
    }

    File getInstallDir(String filename) {
        String installParentDirectory = System.getProperty("user.home");
        IO.println((Object)("SPortExtractor.getInstallDir: installParentDirectory=" + installParentDirectory));
        String msg = "You are about to install a new S-Port System on your computer.\nThis installer will create the directory  '" + simulaInstallSubdirectory + "'\nwithin the Install Directory you select below:\n ";
        Box panel = Box.createVerticalBox();
        JTextArea introLabel = new JTextArea(msg);
        introLabel.setEditable(false);
        introLabel.setBackground(panel.getBackground());
        panel.add(introLabel);
        Box installDirBox = Box.createHorizontalBox();
        installDirBox.add(new JLabel("Install Directory: "));
        this.installDirField = new JTextField(30);
        this.installDirField.setText(installParentDirectory);
        installDirBox.add(this.installDirField);
        JButton browseButton = new JButton("Browse...");
        browseButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                String newInstallDir = SPortExtractor.this.browseForInstallDirectory(SPortExtractor.this.installDirField.getText());
                if (newInstallDir != null) {
                    SPortExtractor.this.installDirField.setText(newInstallDir);
                }
            }
        });
        installDirBox.add(browseButton);
        panel.add(installDirBox);
        String title = "Installing SPort 1.0";
        Object[] options = new Object[]{"Install", "Cancel"};
        int answer = JOptionPane.showOptionDialog(this, panel, title, -1, 3, simulaIcon, options, options[0]);
        if (answer != 0) {
            return null;
        }
        mainFrame.setVisible(true);
        String installDirectory = this.installDirField.getText() + File.separator + simulaInstallSubdirectory;
        INSTALL_DIR = new File(installDirectory);
        if (INSTALL_DIR.exists()) {
            Object[] options2 = new Object[]{"Exit", "Continue"};
            String msg2 = "It looks like the S-Port System is already installed.\nThe selected install directory:\n      " + installDirectory + "\ndoes already exists and may contain important stuff.\n\nDo you want to continue overwriting the files ?\n";
            int result = JOptionPane.showOptionDialog(this, msg2, "Warning", -1, 2, simulaIcon, options2, options2[0]);
            if (result != 1) {
                System.exit(-1);
            }
            File rts = new File(String.valueOf(INSTALL_DIR) + "/rts");
            IO.println((Object)("SPortExtractor.extract: rts=" + String.valueOf(rts)));
            if (rts.exists()) {
                boolean success = this.delete(rts);
                IO.println((Object)("SPortExtractor.extract: rts=" + String.valueOf(rts) + ", deleted=" + success));
            }
        }
        if (!INSTALL_DIR.exists() && !INSTALL_DIR.mkdirs()) {
            msg = "Unable to create directory\n" + installDirectory;
            title = "Error Creating Directory";
            JOptionPane.showMessageDialog(this, msg, title, 0);
            return null;
        }
        if (console != null) {
            console.write("Installing SPort 1.0\nS-Port-Directory:   " + String.valueOf(INSTALL_DIR) + "\n");
        }
        return INSTALL_DIR;
    }

    private boolean delete(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.delete(f);
                ++n2;
            }
        }
        return file.delete();
    }

    private String browseForInstallDirectory(String defaultInstallDir) {
        JFileChooser fc = new JFileChooser();
        IO.println((Object)("SPortExtractor.browseForInstallDirectory: defaultInstallDir=" + defaultInstallDir));
        fc.setCurrentDirectory(new File(defaultInstallDir));
        fc.setDialogType(1);
        fc.setDialogTitle("Select destination directory for extracting S-Port Simula");
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(1);
        if (fc.showDialog(this, "Select") != 0) {
            return null;
        }
        return fc.getSelectedFile().toString();
    }

    private void TRACE(String line) {
        if (console != null) {
            console.write(line + "\n");
        }
    }

    private boolean extract(String zipfileName) {
        File outputDir;
        InputStream in;
        FileOutputStream out;
        ZipFile zf;
        byte[] buf;
        block49: {
            block50: {
                this.TRACE("Trying to extract file " + zipfileName);
                File currentArchive = new File(zipfileName);
                buf = new byte[1024];
                zf = null;
                out = null;
                in = null;
                zf = new ZipFile(currentArchive);
                outputDir = this.getInstallDir(currentArchive.getName());
                if (outputDir != null) break block49;
                try {
                    zf.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (zf == null) break block50;
                try {
                    zf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return true;
        }
        try {
            try {
                int size = zf.size();
                nExtractedFiles = 0;
                Enumeration<? extends ZipEntry> entries = zf.entries();
                int i = 0;
                while (i < size) {
                    String pathname;
                    ZipEntry entry = entries.nextElement();
                    if (!entry.isDirectory() && !(pathname = entry.getName()).startsWith("make/setup")) {
                        if (pathname.toUpperCase().equals("META-INF/MANIFEST.MF")) {
                            SPortExtractor.loadManifest(zf, entry);
                        } else if (!pathname.endsWith(".gitignore")) {
                            int nRead;
                            if (console != null) {
                                console.write("Extracting: " + String.valueOf(entry) + "\n");
                            }
                            in = zf.getInputStream(entry);
                            File outFile = new File(outputDir, pathname);
                            Date archiveTime = new Date(entry.getTime());
                            File parent = new File(outFile.getParent());
                            if (parent != null && !parent.exists()) {
                                parent.mkdirs();
                            }
                            out = new FileOutputStream(outFile);
                            while ((nRead = in.read(buf, 0, buf.length)) > 0) {
                                out.write(buf, 0, nRead);
                            }
                            ++nExtractedFiles;
                            out.close();
                            outFile.setLastModified(archiveTime.getTime());
                        }
                    }
                    ++i;
                }
                zf.close();
                targetDir = outputDir.getPath();
                sPortJarFileName = targetDir + File.separator + "sim.jar";
                String title = "Installed SPort 1.0";
                String msg = "Extracted " + nExtractedFiles + " file" + (nExtractedFiles != 1 ? "s" : "") + " from setup.jar\nInto: " + targetDir;
                File jarFile = new File(sPortJarFileName);
                if (!jarFile.exists()) {
                    JOptionPane.showMessageDialog(this, msg, title, 1);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    private static void askRunSimula() {
        String title = "Installed SPort 1.0";
        String msg = "Extracted " + nExtractedFiles + " file" + (nExtractedFiles != 1 ? "s" : "") + " from setup.jar\nInto: " + targetDir;
        msg = msg + "\n\nThe S-Port executable JAR file is installed at\n" + sPortJarFileName;
        if (compilerBatWasWritten) {
            boolean windows = File.separatorChar == '\\';
            msg = windows ? msg + "\n\nThe file RunSimulaEditor.bat is placed in\n" + String.valueOf(INSTALL_DIR) : msg + "\n\nThe file RunSimulaEditor.sh is placed in\n" + String.valueOf(INSTALL_DIR);
            msg = msg + "\nYou can copy or move it wherever you want\n";
            msg = msg + "and later use it to start the S-Port Editor.\n";
        }
        msg = msg + "\n\nDo you want to start S-Port Simula Editor now ?\n\n";
        int answer = SPortExtractor.optionDialog(msg, title, 0, 3, "Start Editor", "Exit");
        IO.println((Object)("SPortExtractor.extract: answer=" + answer));
        if (answer == 0) {
            new Thread(){

                @Override
                public void run() {
                    SPortExtractor.startJar(sPortJarFileName);
                }
            }.start();
        }
    }

    private static void loadManifest(ZipFile zipFile, ZipEntry entry) throws IOException {
        Manifest manifest = new Manifest(zipFile.getInputStream(entry));
        Attributes main = manifest.getMainAttributes();
        IO.println((Object)("SPortExtractor.loadManifest: Main-Class=" + main.getValue("Main-Class")));
        sPortRevisionID = main.getValue("sPort-Revision");
        setupDated = main.getValue("sPort-Setup-Dated");
        IO.println((Object)("SPortExtractor.loadManifest: This sPort-Revision: " + sPortRevisionID));
        IO.println((Object)("SPortExtractor.loadManifest: This sPort-Setup-Dated: " + setupDated));
        if (console != null) {
            console.write("SPort-Release ID:  SPort-1.0R" + sPortRevisionID + "\n");
            console.write("SPort-Setup-Dated: " + setupDated + "\n");
        }
    }

    private static void startJar(String jar) {
        Runtime rt = Runtime.getRuntime();
        String[] cmd = new String[]{SPortExtractor.getJavaProg(), "-jar", jar};
        try {
            rt.exec(cmd);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Can't run " + String.valueOf(cmd), "Error Running Java", 0);
        }
        System.exit(0);
    }

    private static String getJavaProg() {
        String sep = File.separator;
        return System.getProperty("java.home") + sep + "bin" + sep + "java";
    }

    private static int optionDialog(Object msg, String title, int optionType, int messageType, String ... option) {
        Object OptionPaneBackground = UIManager.get("OptionPane.background");
        Object PanelBackground = UIManager.get("Panel.background");
        UIManager.put("OptionPane.background", Color.WHITE);
        UIManager.put("Panel.background", Color.WHITE);
        int answer = JOptionPane.showOptionDialog(null, msg, title, optionType, messageType, simulaIcon, option, option[0]);
        UIManager.put("OptionPane.background", OptionPaneBackground);
        UIManager.put("Panel.background", PanelBackground);
        return answer;
    }
}

