/*
 * Decompiled with CFR 0.152.
 */
package make.setup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import make.setup.Util;

public final class MakeSetup {
    public static final String RELEASE_ID = "SPort-1.0";
    private static final int REVISION = 3;
    private static final boolean EARLY_ACCESS = false;
    private static final String SETUP_TEMPS = "C:/GitHub/MakeSetup_Temps";
    private static final String RELEASE_HOME = "C:/GitHub/MakeSetup_Temps/SPort-1.0";
    private static final String SPORT_HOME = "C:/SPORT";
    private static final String RELEASE_SAMPLES = "C:/GitHub/MakeSetup_Temps/SPort-1.0/samples";
    private static final String GITHUB_ROOT = "C:/GitHub";
    private static final String SETUP_ROOT = "C:/GitHub/EclipseWorkSpaces/S-Port-Simula/MakeSetup";
    private static final String INSTALLER_BIN = "C:/GitHub/EclipseWorkSpaces/S-Port-Simula/MakeSetup/bin";
    private static String SETUP_IDENT;
    private static File setupPropertiesFile;
    private static Properties setupProperties;

    private static void setSetupIdent() {
        SETUP_IDENT = "SPortSetup";
    }

    public static void main(String[] args) {
        MakeSetup.printHeading("Make Simula Compiler, SETUP_TEMPS=C:/GitHub/MakeSetup_Temps");
        try {
            MakeSetup.setSetupIdent();
            MakeSetup.deleteFiles(SETUP_TEMPS);
            MakeSetup.updateSetupProperties();
            MakeSetup.copySimulaRuntimeSystem();
            MakeSetup.copyFECandBEC();
            MakeSetup.copySimulaIconFiles();
            MakeSetup.copySimulaReleaseTests();
            MakeSetup.makeSimulaInstaller();
            MakeSetup.executeSPortSetup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void updateSetupProperties() {
        String setupDated = String.valueOf(new Date());
        MakeSetup.setProperty("sPort.setup.dated", setupDated);
        MakeSetup.setProperty("sPort.version", RELEASE_ID);
        MakeSetup.setProperty("sPort.revision", "3");
        try {
            String SETUP_SRC = "C:/GitHub/EclipseWorkSpaces/S-Port-Simula/MakeSetup\\src\\make\\setup";
            File installerManifestFile = new File(SETUP_SRC + "\\InstallerManifest.MF");
            IO.println((Object)("installerManifestFile: " + String.valueOf(installerManifestFile)));
            Manifest manifest = new Manifest();
            FileInputStream inputStream = new FileInputStream(installerManifestFile);
            manifest.read(inputStream);
            Attributes main = manifest.getMainAttributes();
            IO.println((Object)("Main-Class: " + main.getValue("Main-Class")));
            IO.println((Object)("sPort-Revision: " + main.getValue("sPort-Revision")));
            main.putValue("sPort-Revision", "3");
            main.putValue("sPort-Setup-Dated", setupDated);
            IO.println((Object)("sPort-Revision: " + main.getValue("sPort-Revision")));
            IO.println((Object)("sPort-Setup-Dated: " + main.getValue("sPort-Setup-Dated")));
            FileOutputStream outputStream = new FileOutputStream(installerManifestFile);
            manifest.write(outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getProperty(String key, String defaultValue) {
        if (setupPropertiesFile == null) {
            MakeSetup.loadProperties();
        }
        return setupProperties.getProperty(key, defaultValue);
    }

    public static void setProperty(String key, String value) {
        if (setupPropertiesFile == null) {
            MakeSetup.loadProperties();
        }
        setupProperties.setProperty(key, value);
        MakeSetup.storeProperties();
    }

    private static void loadProperties() {
        String USER_HOME = System.getProperty("user.home");
        IO.println((Object)("USER_HOME=" + USER_HOME));
        File setupPropertiesDir = new File("C:/GitHub\\github.io\\setup");
        IO.println((Object)("setupPropertiesDir=" + String.valueOf(setupPropertiesDir)));
        setupPropertiesDir.mkdirs();
        setupPropertiesFile = new File(setupPropertiesDir, "setupProperties.xml");
        setupProperties = new Properties();
        try {
            setupProperties.loadFromXML(new FileInputStream(setupPropertiesFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void storeProperties() {
        setupProperties.list(System.out);
        try {
            setupProperties.storeToXML(new FileOutputStream(setupPropertiesFile), "Setup Properties");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void copySimulaRuntimeSystem() throws IOException {
        File source = new File("C:/SPORT/RTS");
        String target = "C:/GitHub/MakeSetup_Temps/SPort-1.0/RTS";
        MakeSetup.printHeading("Copy Simula RuntimeSystem " + String.valueOf(source) + " ===> " + target);
        IO.println((Object)("MakeCompiler.copySimulaRuntimeSystem: target=" + target));
        MakeSetup.copyFolder(source, new File(target), true);
        MakeSetup.list(source);
    }

    private static void copyFECandBEC() throws IOException {
        MakeSetup.printHeading("Copy SIM, FEC and BEC into C:/GitHub/MakeSetup_Temps/SPort-1.0");
        MakeSetup.copyFile("SIM.jar");
        MakeSetup.copyFile("SimulaFEC.jar");
        MakeSetup.copyFile("CommonBEC.jar");
        MakeSetup.copyFile("runSimulaEditor.bat");
    }

    private static void copyFile(String fileName) throws IOException {
        File source = new File("C:/SPORT/" + fileName);
        File target = new File("C:/GitHub/MakeSetup_Temps/SPort-1.0/" + fileName);
        target.mkdirs();
        IO.println((Object)("source=" + String.valueOf(source)));
        IO.println((Object)("target=" + String.valueOf(target)));
        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private static void copySimulaIconFiles() throws IOException {
        MakeSetup.printHeading("Copy Simula Icons .png's into C:/GitHub/MakeSetup_Temps/SPort-1.0");
        MakeSetup.copyImageFile("sim.ico");
        MakeSetup.copyImageFile("sim.png");
        MakeSetup.copyImageFile("sim2.png");
        MakeSetup.copyImageFile("simula.png");
    }

    private static void copyImageFile(String fileName) throws IOException {
        File source = new File("C:/SPORT/icons/" + fileName);
        File target = new File("C:/GitHub/MakeSetup_Temps/SPort-1.0/icons/" + fileName);
        target.mkdirs();
        IO.println((Object)("source=" + String.valueOf(source)));
        IO.println((Object)("target=" + String.valueOf(target)));
        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private static void copySimulaReleaseTests() throws IOException {
        MakeSetup.printHeading("Copy Simula Sample Programs into C:/GitHub/MakeSetup_Temps/SPort-1.0/samples");
        MakeSetup.deleteFiles(RELEASE_SAMPLES);
        MakeSetup.copyFolder(new File("C:/SPORT/Samples"), new File(RELEASE_SAMPLES), false);
        MakeSetup.list(new File("C:/SPORT/Samples"));
        MakeSetup.list(new File(RELEASE_SAMPLES));
        MakeSetup.copyFolder(new File("C:/SPORT/Samples/data"), new File("C:/GitHub/MakeSetup_Temps/SPort-1.0/samples/data"), false);
    }

    private static void deleteFiles(String dirName) {
        try {
            File tmpClass = new File(dirName);
            File[] elt = tmpClass.listFiles();
            if (elt == null) {
                return;
            }
            File[] fileArray = elt;
            int n = elt.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    MakeSetup.deleteFiles(f.getPath());
                }
                f.delete();
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void copyFolder(File source, File target, boolean copySubFolders) throws IOException {
        IO.println((Object)("COPY: " + String.valueOf(source) + " ==> " + String.valueOf(target)));
        target.mkdirs();
        File[] fileArray = source.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            File fileDest = new File(target, file.getName());
            if (file.isDirectory()) {
                if (copySubFolders) {
                    MakeSetup.copyFolder(file, fileDest, copySubFolders);
                }
            } else {
                Files.copy(file.toPath(), fileDest.toPath(), new CopyOption[0]);
            }
            ++n2;
        }
    }

    private static void list(File dir) {
        try {
            Util.println("------------  LIST " + String.valueOf(dir) + "  ------------");
            MakeSetup.list("", dir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void list(String indent, File dir) {
        try {
            File[] elt = dir.listFiles();
            if (elt == null || elt.length == 0) {
                Util.println("Empty Directory: " + String.valueOf(dir));
                return;
            }
            Util.println("Elements: " + elt.length);
            File[] fileArray = elt;
            int n = elt.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                Util.println(indent + "- " + MakeSetup.getModifiedTime(f) + "  " + String.valueOf(f));
                if (f.isDirectory()) {
                    MakeSetup.list(indent + "   ", f);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getModifiedTime(File file) {
        try {
            Path path = Paths.get(file.toString(), new String[0]);
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return attr.lastModifiedTime().toString().substring(0, 19).replace('T', ' ');
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void makeSimulaInstaller() throws IOException {
        MakeSetup.printHeading("Make Simula Setup.jar in C:/GitHub/MakeSetup_Temps");
        File releaseHome = new File(RELEASE_HOME);
        releaseHome.mkdirs();
        String SETUP_SRC = "C:/GitHub/EclipseWorkSpaces/S-Port-Simula/MakeSetup/src/make/setup";
        File source = new File(SETUP_SRC + "/sim.png");
        File target = new File("C:/GitHub/EclipseWorkSpaces/S-Port-Simula/MakeSetup/bin/make/setup/sim.png");
        target.mkdirs();
        IO.println((Object)("source=" + String.valueOf(source)));
        IO.println((Object)("target=" + String.valueOf(target)));
        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        String installerManifest = SETUP_SRC + "/InstallerManifest.MF";
        String files = " -C C:/GitHub/MakeSetup_Temps/SPort-1.0. -C C:/GitHub/EclipseWorkSpaces/S-Port-Simula/MakeSetup/bin ./make/setup";
        IO.println((Object)("jar cmf " + installerManifest + " C:/GitHub/MakeSetup_Temps/" + SETUP_IDENT + ".jar" + files));
        MakeSetup.exec("jar", "cmf", installerManifest, "C:/GitHub/MakeSetup_Temps/" + SETUP_IDENT + ".jar", "-C", RELEASE_HOME, ".", "-C", INSTALLER_BIN, "./make/setup");
        MakeSetup.printHeading("BEGIN -- List Simula Setup.jar in C:/GitHub/MakeSetup_Temps");
        MakeSetup.exec("jar", "-tvf", "C:/GitHub/MakeSetup_Temps/" + SETUP_IDENT + ".jar");
        MakeSetup.printHeading("END -- List Simula Setup.jar in C:/GitHub/MakeSetup_Temps");
        MakeSetup.copySetupJAR();
    }

    private static void copySetupJAR() throws IOException {
        File source = new File("C:/GitHub/MakeSetup_Temps/" + SETUP_IDENT + ".jar");
        File target2 = new File("C:/GitHub/github.io/setup/" + SETUP_IDENT + ".jar");
        IO.println((Object)("source=" + String.valueOf(source)));
        IO.println((Object)("target2=" + String.valueOf(target2)));
        Files.copy(source.toPath(), target2.toPath(), StandardCopyOption.REPLACE_EXISTING);
        String SETUP_IDENT_WITH_REVISION = SETUP_IDENT + "-R3.jar";
        File target1 = new File("C:/GitHub/github.io/setup/" + SETUP_IDENT_WITH_REVISION);
        IO.println((Object)("target1=" + String.valueOf(target1)));
        Files.copy(source.toPath(), target1.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private static void executeSPortSetup() throws IOException {
        String SETUP_JAR = "C:/GitHub/github.io/setup/" + SETUP_IDENT + ".jar";
        MakeSetup.printHeading("Execute SPortSetup: " + SETUP_JAR);
        MakeSetup.exec("java", "-jar", SETUP_JAR);
    }

    public static int exec(String ... cmd) throws IOException {
        Object cmdLine = "";
        int i = 0;
        while (i < cmd.length) {
            cmdLine = (String)cmdLine + " " + cmd[i];
            ++i;
        }
        IO.println((Object)("SIM.Util.exec: command =" + (String)cmdLine));
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        IO.println((Object)("SIM.Util.exec: processBuilder = " + String.valueOf(processBuilder)));
        processBuilder.inheritIO();
        processBuilder.redirectErrorStream();
        try {
            Process process = processBuilder.start();
            IO.println((Object)("SIM.Util.exec: process = " + String.valueOf(process)));
            int exitCode = process.waitFor();
            IO.println((Object)("SIM.Util.exec: exitCode = " + exitCode));
            return exitCode;
        }
        catch (Exception e) {
            e.printStackTrace();
            Util.IERR("SIM.Util.exec: Process Execution failed: " + (String)cmdLine + "  " + String.valueOf(e));
            return -1;
        }
    }

    private static void printHeading(String heading) {
        IO.println((Object)"************************************************************************************************************************************");
        IO.println((Object)("*** " + heading));
        IO.println((Object)"************************************************************************************************************************************");
    }
}

