/*
 * Decompiled with CFR 0.152.
 */
package make.setup;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import make.setup.Util;

public final class Console
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static JTextPane textPane;
    private StyledDocument doc;
    private Style styleRegular;
    private Style styleWarning;
    private Style styleError;
    private JPopupMenu popupMenu;
    private JMenuItem clearItem;
    private JMenuItem copyItem;
    private boolean reading;
    private char keyin;
    private Reader consoleReader;
    MouseListener mouseListener = new MouseListener(){

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                Console.this.popupMenu.show(textPane, e.getX(), e.getY());
            }
        }
    };
    ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object item = e.getSource();
            if (item == Console.this.clearItem) {
                Console.this.clear();
            } else if (item == Console.this.copyItem) {
                String text = textPane.getSelectedText();
                if (text == null) {
                    text = textPane.getText();
                }
                StringSelection stringSelection = new StringSelection(text);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            }
        }
    };
    private KeyListener listener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent event) {
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (Console.this.reading) {
                Console.this.keyin = event.getKeyChar();
                Console.this.reading = false;
            }
        }
    };

    public char read() {
        textPane.requestFocus();
        this.reading = true;
        while (this.reading) {
            Thread.yield();
        }
        return this.keyin;
    }

    public Reader getReader() {
        if (this.consoleReader == null) {
            this.consoleReader = new Reader(){

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    int firstPos = textPane.getCaretPosition();
                    textPane.setEditable(true);
                    while (Console.this.read() != '\n') {
                    }
                    textPane.setEditable(false);
                    String input = textPane.getText().substring(firstPos);
                    int pos = 0;
                    char[] cArray = input.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        cbuf[off + pos++] = c;
                        ++n2;
                    }
                    return pos;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
        return this.consoleReader;
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                String s = "" + (char)b;
                Console.this.write(s, Console.this.styleRegular);
            }
        };
    }

    public PrintStream getPrintStream() {
        return new PrintStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                String s = "" + (char)b;
                Console.this.write(s, Console.this.styleRegular);
            }
        });
    }

    public Writer getWriter() {
        return new Writer(){

            @Override
            public void write(String s) {
                Console.this.write(s);
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                Console.this.write(new String(cbuf, off, len));
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public OutputStream getErrorStream() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                String s = "" + (char)b;
                Console.this.write(s, Console.this.styleError);
            }
        };
    }

    public void write(String s) {
        this.write(s, this.styleRegular);
    }

    public void writeError(String s) {
        this.write(s, this.styleError);
    }

    public void writeWarning(String s) {
        this.write(s, this.styleWarning);
    }

    private void write(String s, Style style) {
        try {
            this.doc.insertString(this.doc.getLength(), s, style);
        }
        catch (BadLocationException e) {
            Util.IERR("Impossible: " + String.valueOf(e));
        }
        textPane.setCaretPosition(textPane.getDocument().getLength());
    }

    public void clear() {
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException e) {
            Util.IERR("Impossible: " + String.valueOf(e));
        }
        textPane.setCaretPosition(textPane.getDocument().getLength());
        textPane.update(textPane.getGraphics());
    }

    public Console() {
        super(new BorderLayout());
        textPane = new JTextPane();
        textPane.addMouseListener(this.mouseListener);
        JScrollPane scrollPane = new JScrollPane(textPane);
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setHorizontalScrollBarPolicy(30);
        this.doc = new DefaultStyledDocument();
        this.addStylesToDocument(this.doc);
        this.doc.putProperty("__EndOfLine__", "\n");
        textPane.setStyledDocument(this.doc);
        textPane.addKeyListener(this.listener);
        textPane.setEditable(false);
        this.popupMenu = new JPopupMenu();
        this.clearItem = new JMenuItem("Clear Console");
        this.popupMenu.add(this.clearItem);
        this.clearItem.addActionListener(this.actionListener);
        this.copyItem = new JMenuItem("Copy to Clipboard");
        this.copyItem.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        this.popupMenu.add(this.copyItem);
        this.copyItem.addActionListener(this.actionListener);
        this.add(scrollPane);
    }

    public void popup() {
        JFrame frame = new JFrame();
        frame.setSize(950, 500);
        frame.setTitle("Runtime Console");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(this);
        frame.setVisible(true);
    }

    private void addStylesToDocument(StyledDocument doc) {
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", defaultStyle);
        StyleConstants.setFontFamily(defaultStyle, "Courier New");
        Style s = doc.addStyle("warning", regular);
        StyleConstants.setItalic(s, true);
        StyleConstants.setForeground(s, new Color(255, 153, 0));
        s = doc.addStyle("error", regular);
        StyleConstants.setBold(s, true);
        StyleConstants.setForeground(s, Color.RED);
        this.styleRegular = doc.getStyle("regular");
        this.styleWarning = doc.getStyle("warning");
        this.styleError = doc.getStyle("error");
    }
}

